// $Id: CPrecisionTimer.cpp,v 1.2 2007/02/08 21:06:44 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CPrecisionTimer.hpp"
using Exponent::Testing::CPrecisionTimer;

//	===========================================================================
bool CPrecisionTimer::CPRECISION_TIMER_INITIALISED = false;

//	===========================================================================
double CPrecisionTimer::CPRECISION_TIMER_INV_FREQUENCY = 0.0;

//	===========================================================================
void CPrecisionTimer::initialise()
{
    if (!CPRECISION_TIMER_INITIALISED)
    {
        CPRECISION_TIMER_INITIALISED = true;

#ifdef WIN32
        LARGE_INTEGER freq;
        if(!QueryPerformanceFrequency(&freq) || freq.QuadPart == 0)
        {
            return;
        }
        CPRECISION_TIMER_INV_FREQUENCY = 1.0 / (double)(freq.QuadPart);
#else
        CPRECISION_TIMER_INV_FREQUENCY = 1.0;
#endif
    }
}

//	===========================================================================
CPrecisionTimer::CPrecisionTimer() : m_counter(0), m_sampleRate(0)
{
	// Nothing to do...
}

//	===========================================================================
CPrecisionTimer::~CPrecisionTimer()
{
	// Nothing to do...
}

//	===========================================================================
void CPrecisionTimer::startTimer()
{
#ifdef WIN32
    QueryPerformanceCounter((LARGE_INTEGER*)&m_counter);
#else
    m_counter = mach_absolute_time();
#endif
}

//	===========================================================================
double CPrecisionTimer::getProcessorTime()
{
#ifdef WIN32
    uint64 counter2;
    QueryPerformanceCounter((LARGE_INTEGER*)&counter2);
    uint64 counterDifference = counter2 - m_counter;
	//m_counter = counter2;
	const double t = (double)(counterDifference) * CPRECISION_TIMER_INV_FREQUENCY;
    return t;
#else
    uint64 counter2			 = mach_absolute_time ();
    uint64 counterDifference = counter2 - m_counter;
	//m_counter = counter2;
    Nanoseconds nanoSeconds  = AbsoluteToNanoseconds(*(AbsoluteTime*)&counterDifference);
    return ((long)(*(uint64*)&nanoSeconds)) * 1e-9;
#endif
}

//	===========================================================================
double CPrecisionTimer::getCPUUsage(const long numberOfSamples)
{
	return this->getProcessorTime() / numberOfSamples * m_sampleRate;
}